package gov.va.med.mhv.usermgmt.util.activity;

import gov.va.med.mhv.usermgmt.common.dto.ActivityDTO;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActionTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityActorTypeEnumeration;
import gov.va.med.mhv.usermgmt.common.enums.ActivityTypeEnumeration;

import java.util.Date;

public class ActivityHelper {
	
	public static ActivityDTO createActivityDTO(Long userProfileId, ActivityActorTypeEnumeration actor, boolean status, 
			ActivityTypeEnumeration activityType, ActivityActionTypeEnumeration action, String detailValue) {

		assert(userProfileId!=null);
		assert(actor!=null);
		assert(activityType!=null);
		assert(action!=null);
		
		ActivityDTO activity = new ActivityDTO();
		
		activity.setUserProfileId(userProfileId);
		activity.setActivityType(activityType.getDescription());
		activity.setAction(action.getDescription());
		activity.setCompletionTime(new Date());
		activity.setPerformerType(actor.getDescription());
		activity.setStatus(status);
		activity.setDetailValue(detailValue);
		
		return activity;
	}
	
	public static ActivityDTO createActivityDTOForSelf(Long userProfileId, boolean status, 
			ActivityTypeEnumeration activityType, ActivityActionTypeEnumeration action, String detailValue) {

		assert(userProfileId!=null);
		assert(activityType!=null);
		assert(action!=null);
		
		ActivityDTO activity = new ActivityDTO();
		activity.setUserProfileId(userProfileId);
		activity.setActivityType(activityType.getDescription());
		activity.setAction(action.getDescription());
		activity.setCompletionTime(new Date());
		activity.setPerformerType(ActivityActorTypeEnumeration.SELF.getDescription());
		activity.setStatus(status);
		activity.setDetailValue(detailValue);
		
		return activity;
	}
	
	public static ActivityDTO createActivityDTOForSystem(Long userProfileId, boolean status, 
			ActivityTypeEnumeration activityType, ActivityActionTypeEnumeration action, String detailValue) {

		assert(userProfileId!=null);
		assert(activityType!=null);
		assert(action!=null);
		
		ActivityDTO activity = new ActivityDTO();
		activity.setUserProfileId(userProfileId);
		activity.setActivityType(activityType.getDescription());
		activity.setAction(action.getDescription());
		activity.setCompletionTime(new Date());
		activity.setPerformerType(ActivityActorTypeEnumeration.SYSTEM.getDescription());
		activity.setStatus(status);
		activity.setDetailValue(detailValue);
		
		return activity;
	}
	
	public static ActivityDTO createActivityDTOForHealthCareProxyFull(Long userProfileId, boolean status, 
			ActivityTypeEnumeration activityType, ActivityActionTypeEnumeration action, String detailValue) {

		assert(userProfileId!=null);
		assert(activityType!=null);
		assert(action!=null);
		
		ActivityDTO activity = new ActivityDTO();
		activity.setUserProfileId(userProfileId);
		activity.setActivityType(activityType.getDescription());
		activity.setAction(action.getDescription());
		activity.setCompletionTime(new Date());
		activity.setPerformerType(ActivityActorTypeEnumeration.HEALTHCARE_PROXY_FULL.getDescription());
		activity.setStatus(status);
		activity.setDetailValue(detailValue);
		
		return activity;
	}	
	
	
}
